/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.network;

import appeng.core.AppEng;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.ClientPacketHandler;
import appeng.core.sync.network.IPacketHandler;
import appeng.core.sync.network.ServerPacketHandler;
import appeng.core.sync.network.TargetPoint;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.event.EventNetworkChannel;

public class NetworkHandler {
    private static NetworkHandler instance;
    private final ResourceLocation myChannelName;
    private final IPacketHandler clientHandler;
    private final IPacketHandler serverHandler;

    public NetworkHandler(ResourceLocation channelName) {
        this.myChannelName = channelName;
        EventNetworkChannel ec = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.myChannelName).networkProtocolVersion(() -> "1").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).eventNetworkChannel();
        ec.registerObject((Object)this);
        this.clientHandler = (IPacketHandler)DistExecutor.unsafeRunForDist(() -> ClientPacketHandler::new, () -> () -> null);
        this.serverHandler = this.createServerSide();
    }

    public static void init(ResourceLocation channelName) {
        instance = new NetworkHandler(channelName);
    }

    public static NetworkHandler instance() {
        return instance;
    }

    private IPacketHandler createServerSide() {
        try {
            return new ServerPacketHandler();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @SubscribeEvent
    public void serverPacket(NetworkEvent.ClientCustomPayloadEvent ev) {
        if (this.serverHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
                ServerGamePacketListenerImpl netHandler = (ServerGamePacketListenerImpl)ctx.getNetworkManager().m_129538_();
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> this.serverHandler.onPacketData((PacketListener)netHandler, ev.getPayload(), (Player)netHandler.f_9743_));
            }
            catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void clientPacket(NetworkEvent.ServerCustomPayloadEvent ev) {
        if (ev instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
            return;
        }
        if (this.clientHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)ev.getSource().get();
                PacketListener netHandler = ctx.getNetworkManager().m_129538_();
                ctx.setPacketHandled(true);
                ctx.enqueueWork(() -> this.clientHandler.onPacketData(netHandler, ev.getPayload(), null));
            }
            catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                // empty catch block
            }
        }
    }

    public ResourceLocation getChannel() {
        return this.myChannelName;
    }

    public void sendToAll(BasePacket message) {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server != null) {
            server.m_6846_().m_11268_(message.toPacket(NetworkDirection.PLAY_TO_CLIENT));
        }
    }

    public void sendTo(BasePacket message, ServerPlayer player) {
        player.f_8906_.m_141995_(message.toPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    public void sendToAllAround(BasePacket message, TargetPoint point) {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server != null) {
            Packet<?> pkt = message.toPacket(NetworkDirection.PLAY_TO_CLIENT);
            server.m_6846_().m_11241_((Player)point.excluded, point.x, point.y, point.z, point.r2, point.level.m_46472_(), pkt);
        }
    }

    public void sendToServer(BasePacket message) {
        Minecraft.m_91087_().m_91403_().m_104955_(message.toPacket(NetworkDirection.PLAY_TO_SERVER));
    }
}

